/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.AbstractEngineContext;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.step.StepEngine;
import com.quantumdata.sct.engine.step.StepEngineContext;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JPanel;

public class TestEngineContext
extends AbstractEngineContext {
    private TestVO testVO;
    private Hashtable testStepEngines;
    private TestResultVO testResultVO;
    private boolean userFound = false;

    TestEngineContext(TestVO testVO) throws Exception {
        this.testVO = testVO;
        this.testStepEngines = new Hashtable();
        this.testResultVO = new TestResultVO();
        this.testResultVO.setCapabilityId(testVO.getId().toString());
    }

    private StepEngine getStepEngine(AbstractStepVO abstractStepVO) {
        if (this.testStepEngines.containsKey(abstractStepVO)) {
            return (StepEngine)this.testStepEngines.get(abstractStepVO);
        }
        StepEngine stepEngine = (StepEngine)abstractStepVO.createEngine();
        this.testStepEngines.put(abstractStepVO, stepEngine);
        return stepEngine;
    }

    public boolean executeStep(AbstractStepVO abstractStepVO) throws Exception {
        IEngineContext iEngineContext;
        StepEngine stepEngine = this.getStepEngine(abstractStepVO);
        if (stepEngine.execute(iEngineContext = stepEngine.prepareContext(this)) != 0) {
            return false;
        }
        this.copyFrom(iEngineContext, true, true);
        return true;
    }

    public void copyFrom(IEngineContext iEngineContext, boolean bl, boolean bl2) {
        super.copyFrom(iEngineContext, bl, bl2);
        try {
            if (iEngineContext != null && iEngineContext instanceof StepEngineContext) {
                this.testResultVO.add(((StepEngineContext)iEngineContext).getStepResultVO());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TestResultVO getTestResultVO() {
        return this.testResultVO;
    }

    public void setTestResultVO(TestResultVO testResultVO) {
        this.testResultVO = testResultVO;
    }

    public TestVO getTest() {
        return this.testVO;
    }

    public short getType() {
        return 1;
    }

    public JPanel getStepDisplay(AbstractStepVO abstractStepVO, int n) {
        StepEngine stepEngine = this.getStepEngine(abstractStepVO);
        Properties properties = new Properties();
        properties.setProperty("StepCountValue", String.valueOf(n));
        JPanel jPanel = stepEngine.getDisplay(properties);
        this.userFound = stepEngine.isUserStep();
        return jPanel;
    }

    public boolean isUserStep() {
        boolean bl = this.userFound;
        this.userFound = false;
        return bl;
    }
}

